package gov.va.vinci.dart.json.builder;

import java.text.SimpleDateFormat;

import gov.va.vinci.dart.RequestController;
import gov.va.vinci.dart.biz.DartRequest;
import gov.va.vinci.dart.biz.OperationalRequest;
import gov.va.vinci.dart.biz.PreparatoryRequest;
import gov.va.vinci.dart.biz.Request;
import gov.va.vinci.dart.biz.Task;
import gov.va.vinci.dart.json.TaskView;

public class TaskViewBuilder {

	public static final SimpleDateFormat SDF = new SimpleDateFormat("MM/dd/yyyy");

	public TaskView build(final Request request, final Task task, final boolean isReview) {
		TaskView result = new TaskView();
		
		result.setTaskId(task.getId());
		result.setTrackingNumber(request.getTrackingNumber());
		result.setDateReceived(SDF.format(task.getCreatedOn()));
		result.setActivityName(request.getName());
		
		//set the request type, based on the workflow type
		if (DartRequest.class.isAssignableFrom(request.getClass())) {
			result.setActivityType(Request.DATA_ACCESS);			
			result.setResearchRequest(true);
		} else if (PreparatoryRequest.class.isAssignableFrom(request.getClass())) {
            result.setActivityType(Request.PREPARATORY_TO_RESEARCH_ACCESS);         
            result.setPreparatoryRequest(true);          
        }
		else if (OperationalRequest.class.isAssignableFrom(request.getClass())) {
			result.setActivityType(Request.OPERATIONS_DATA_ACCESS);			
			result.setOperationsRequest(true);			
		}

		// get the Primary Investigator
		result.setContact( request.getPrincipalInvestigator() );
		
		result.setDescription(task.getDescription());
		result.setActivityId(request.getActivity().getId());
		result.setRequestId(request.getId());
		result.setReviewId(task.getReview()==null?0:task.getReview().getId());					
		
		result.setReviewTask(isReview);	//is this a review task? (group or person task)
		
		return result;
	}
}
